//
//  POSSDK.h
//  POSSDK
//
//  Created by duyuzhen on 13-6-26.
//  Copyright (c) 2013 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "WIFIPort.h"
#import "POSCommand.h"

@interface POSSDK : NSObject

/***************************************************************************************************
 * function:Set communication module instance for printer
 * Param list:port_io:Instance has been connected to printer 
 * return：Procrssing was successful -- SUCCESS; Port_IO is not the object of PortIO,0r the object isinvalis -- ERR_INVALID_ARGUMENT
**************************************************************************************************/
- (SInt32)systemSetPortIO:(PortIO*)Port_IO;

/***************************************************************************************************
 * function:Set encoding for Text Print
 * Param list:encoding: the Text ecoding 
 * return：Procrssing was successful --SUCCESS
**************************************************************************************************/
- (SInt32)systemSetEncoding:(CFStringEncoding)encoding;

/***************************************************************************************************
 * function: Download File
 * Param list: FileName:the file name would be download
 * return： SUCCESS,ERR_COMMUNICATE,ERR_INVALID_ARGUMENT
**************************************************************************************************/
- (SInt32)systemDownloadFile:(NSString*)FileName DownloadTimeOut:(SInt32)DownloadTimeOut;

/***************************************************************************************************
 * function:Initialize printer,clear data in print buffer and set print mode to the default mode when powered on
 * Param list: None
 * return：Procrssing was success -- SUCCESS
 *         Printer resetting failed -- ERR_SYSTEM_RESET
**************************************************************************************************/
- (SInt32)systemReset;

/***************************************************************************************************
 * function:select print mode 
 * Param list: PrintMode:PrintModeStandard -- enter standard mode ,PrintModePage -- enter page mode
 * return：Procrssing was success -- SUCCESS,Invalid parameter was passed -- ERR_INVALID_ARGUMENT,The print mode selecting failed -- ERR_SYSTEM_SELECT_PRINT_MODE       
**************************************************************************************************/
- (SInt32)systemSelectPrintMode:(SInt32)PrintMode;

/***************************************************************************************************
 * function:select paper type
 * Param list: PaperType:PaperTypeCoutinuous -- select  continuous paper;PaperTypeMarked-- select  marked paper
 * return： SUCCESS,EERR_INVALID_ARGUMENT,The paper type selecting failed -- ERR_SYSTEM_SELECT_PAPER_TYPE
**************************************************************************************************/
- (SInt32)systemSelectPaperType:(SInt32)PaperType;

/***************************************************************************************************
 * function:Set the horizontal and vertical motion units
 * Param list: HorizontalUnit:[0 255];VerticalUnit:[0 255]
 * return： SUCCESS,ERR_INVALID_ARGUMENT, The motion uint selecting failed -- ERR_SYSTEM_SET_MOTION_UNIT
**************************************************************************************************/
- (SInt32)systemSetMotionUnit:(SInt32)HorizontalUnit VerticalUnit:(SInt32)VerticalUnit;

/***************************************************************************************************
 * function:Query Status for WIFI
 * Param list: QueryStatusBuffer:The buffer for storing printer's status
 *             ReadSize:The number of bytes which would be read.
 * return： Procrssing was success -- SUCCESS,
 *          The bytes of return are different from Bytes of datas which will be read -- ERR_COMMUNICATE ,
 *          The printer’s status querying failed -- ERR_SYSTEM_QUERY_STATUS
**************************************************************************************************/
- (SInt32)systemQueryStatus:(UInt8*)QueryStatusBuffer ReadSize:(SInt32)ReadSize;
//- (SInt32)systemQueryStatusWIFI:(UInt8*)QueryStatusBuffer ReadSize:(SInt32)ReadSize;

/***************************************************************************************************
 * function:Query Status for BlueTooth
 * Param list: QueryStatusBuffer:The buffer for storing printer's status
 *             ReadSize:The number of bytes which would be read.
 * return： Procrssing was success -- SUCCESS,
 *          The bytes of return are different from Bytes of datas which will be read -- ERR_COMMUNICATE ,
 *          The printer’s status querying failed -- ERR_SYSTEM_QUERY_STATUS
 **************************************************************************************************/
//- (SInt32)systemQueryStatusBlueTooth:(UInt8*)QueryStatusBuffer ReadSize:(SInt32)ReadSize;

/***************************************************************************************************
 * function:Print and line feed
 * Param list: LineNum:the number of feed line ( >= 1)
 * return： SUCCESS,ERR_INVALID_ARGUMENT,Feed line failed -- ERR_SYSTEM_FEED_LINE
**************************************************************************************************/
- (SInt32)systemFeedLine:(SInt32)LineNum;

/***************************************************************************************************
 * function: Select cut paper mode and cut paper
 * Param list: CutMode: CutFullImmdediately  -- Full cut; CutPartImmedediately -- Half cut; CutPartAfterFeed-- Feed and Part cut
 *             FeedDistance:Feed paper distance[0 255]
 * return： SUCCESS,ERR_INVALID_ARGUMENT,The paper cutting failed -- ERR_SYSTEM_CUT_PAPER
**************************************************************************************************/
- (SInt32)systemCutPaper:(SInt32)CutMode FeedDistance:(SInt32)FeedDistance;

/***************************************************************************************************
 * function: Output the cash drawer control pulse to specified connector pin
 * Param list: CashdrawerID: [0 1], 0 – Pin2; 1 – Pin5; Fee * PulseOnTimes : [0 255]; PulseOffTimes: [0 255]
 * return： SUCCESS,ERR_INVALID_ARGUMENT,The cashdrawer opening failed -- ERR_CASH_DRAWER_OPEN
**************************************************************************************************/
- (SInt32)cashdrawerOpen:(SInt32)CashdrawerID PulseOnTimes:(SInt32)PulseOnTimes PulseOffTimes:(SInt32)PulseOffTimes;

/***************************************************************************************************
 * function: Select an international character set and Code page
 * Param list:CharSet: CharacterSetUSA /CharacterSetFrance/CharacterSetGermany/CharacterSetUK/CharacterSetDenmark_I/CharacterSetSweden/CharacterSetItaly/CharacterSetSpain_I/CharacterSetJapan/CharacterSetNorway/CharacterSetDenmark_II/CharacterSetSpain_II/CharacterSetLatin_America/ CharacterSetKorea
 *          CodePage:Code PageCodePage: CodePagePC437\CodePageKatakana\CodePagePC850\CodePagePC860\CodePagePC863\CodePagePC865\CodePage851_Greek\CodePagePC857\CodePage737_Greek\CodePage928_Greek\ CodePageWPC125\CodePagePC866\CodePagePC852\CodePagePC858\CodePageThaiTis42_Thai3\ CodePageThaiTis11_Thai5\CodePageThaiTis_Thai2\CodePageThaiKu_Thai1\CodePageThaiTis14_Thai4\ CodePageThaiTis18_Thai6\CodePageHebrew1\CodePageHebrew2\CodePageHebrew3\CodePage775_Baltic\ CodePage855_Cyrillic\CodePage862_hebrew\CodePage864_Arabic\CodePage869_Greek\CodePageFrasi\ CodePage772_Lithuanian\CodePage1250_Latin_2\CodePage1251_Cyrillic\CodePage1253_Greek\ CodePage1254_Turkish\CodePage1255_Hebrew\CodePage1256_Arabic\CodePage1257_Baltic\CodePage771\ CodePage774_Lithuanian\CodePage3840_IBM_Russian\CodePage3841_Gost\CodePage3843_Polish\ CodePage3844_CS2\CodePage3845_Hungarian\CodePage3846_Turkish\CodePage3847_Brazil_ABNT\ CodePage3848_Brazil_ABICOMP\CodePage1001\CodePage2001\CodePage3001_Estonian_1\CodePage3002_Estonian_2\CodePage3011_Latvian_1\CodePage3012_Latvian_2\CodePage3021_Bulgarian      \CodePage3041_Maitese\ CodePage8859\CodePagePersia 
 * return： SUCCESS,ERR_INVALID_ARGUMENT,
 *          The char set selecting failed -- ERR_TEXT_SELECT_CHAR_SET
 *          The code page selecting failed -- ERR_TEXT_SELECT_CODE_PAGE
**************************************************************************************************/
- (SInt32)textSelectCharSetAndCodePage:(SInt32)CharSet codePage:(SInt32)CodePage;

/***************************************************************************************************
 * function: Set line height
 * Param list: Height:the line spacing [0 255]
 * return：  SUCCESS,ERR_INVALID_ARGUMENT,The line height setting failed -- ERR_TEXT_SET_LINE_HEIGHT
**************************************************************************************************/
- (SInt32)textSetLineHeight:(SInt32)Height;

/***************************************************************************************************
 * function: Set character spacing
 * Param list: LeftSpace: the character spacing for the left side of the character to inch [0 255]
 *             RightSpace: the character spacing for the right side of the character to inch [0 255]
 *             Mode:EnglishCharacterMode\ChineseCharacterMode
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          The character space setting failed -- ERR_TEXT_SET_CHARACTER_SPACE
**************************************************************************************************/
- (SInt32)textSetCharacterSpace:(SInt32)LeftSpace RightSpace:(SInt32)RightSpace Mode:(SInt32)Mode;

/***************************************************************************************************
 * function: Align all the data in one line to the specified position
 * Param list: Alignment: TextAlignmentLeft – Left Justification; TextAlignmentCenter –Centering;
 TextAlignmentRight –Right Justification;
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          The alignment mode selecting failed -- ERR_TEXT_STANDARD_MODE_ALIGNMENT
**************************************************************************************************/
- (SInt32)textStandardModeAlignment:(SInt32)Alignment;

/***************************************************************************************************
 * function: Enter bi-colour print mode and set print color
 * Param list:none
 * return： Processing was successful -- SUCCESS
 *          Failed to enter bi-color printing -- ERR_TEXT_ENTER_QUIT_COLOR_PRINT
 *          Color setting failed  -- ERR_TEXT_SET_COLOR_PRINT
**************************************************************************************************/
- (SInt32)textSetColorPrint;

/***************************************************************************************************
 * function: Quit bi-colour print mode
 * Param list:none
 * return： SUCCESS
 *          Failed to quit bi-color printing -- ERR_TEXT_ENTER_QUIT_COLOR_PRINT
**************************************************************************************************/
- (SInt32)textQuitColorPrint;

/***************************************************************************************************
 * function: User-defined character is enable/disable. 
 * Param list: Enable: Font User Defined Enable or not, FontUserDefinedDisable -- disable; FontUserDefinedEnable -- enable
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          User-defined enable failed -- ERR_TEXT_FONT_USER_DEFINED_ENABLE
**************************************************************************************************/
- (SInt32)textUserDefinedCharacterEnable:(SInt32)Enable;

/***************************************************************************************************
 * function: Define User-defined  character 
 * Param list: BytesOfHeight: Bytes Of Height      3
 *             StartingCharCode:Starting Char Code [32 127]
 *             EndingCharCode:Ending Char Code     [32 127]
 *             DotsOfWidth: Dots Of Width          9 or 12
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          User-defined character defining failed -- ERR_TEXT_FONT_USER_DEFINED
**************************************************************************************************/
- (SInt32)textUserDefinedCharacterDefine:(SInt32)BytesOfHeight DotsOfWidth:(SInt32)DotsOfWidth StartingCode:(SInt32)StartingCode EndingCode:(SInt32)EndingCode CharacterData:(NSData*)CharacterData;

/***************************************************************************************************
 * function: Text Cancel Font User Defined of CharCode
 * Param list: CharCode: the CharCode of CancelCharacter [32 127]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          User-defined character canceling failed -- ERR_TEXT_FONT_USER_DEFINED_CANCEL
**************************************************************************************************/
- (SInt32)textUserDefinedCharacterCancel:(SInt32)CharCode;

/***************************************************************************************************
 * function: Define User Defined  Font for Chinese Character
 * Param list: BytesOfHeight: Bytes Of Height      3
 *             DotsOfWidth: Dots Of Width          24
 *             Code:the seconde code of Chinese character [A1 -FE]
 *             CharacterData:the data of User Defined Chinese Character
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          User-defined Chinese character defining failed -- ERR_TEXT_FONT_USER_DEFINED
**************************************************************************************************/
- (SInt32)textUserDefinedChineseCharacterDefine:(SInt32)BytesOfHeight DotsOfWidth:(SInt32)DotsOfWidth Code:(SInt32)Code CharacterData:(NSData*)CharacterData;

/***************************************************************************************************
 * function: Turn on/off upside-down printing mode
 * Param list: UpsideDown: upside-down printing mode is turned off or on , other value is turned off; FontStyleUpsideDown  –-  turned on
 * return： SUCCESS,ERR_INVALID_ARGUMENT, Upside-down failed -- ERR_TEXT_STANDARD_MODE_UPSIDEDOWN
**************************************************************************************************/
- (SInt32)textStandardModeUpsideDown:(SInt32)UpsideDown;

/***************************************************************************************************
 * function: print text
 * Param list: String:the content would be printed
 * return： SUCCESS,String==nil -- ERR_INVALID_ARGUMENT,The text printing failed -- ERR_TEXT_PRINT
**************************************************************************************************/
- (SInt32)textPrint:(NSString*)String;

/***************************************************************************************************
 * function: print text
 * Param list: buffer:the unsigned char data be printed
 *             length:the length of data
 * return： SUCCESS,Buffer==nil -- ERR_INVALID_ARGUMENT,The text printing failed -- ERR_TEXT_PRINT
**************************************************************************************************/
- (SInt32)textPrint:(UInt8*)Buffer Length:(SInt32)Length;

/***************************************************************************************************
 * function: Select character size
 * Param list: HorizontalTimes:Horizontal number of Times(1-6)
 *             VerticalTimes:Vertical number of Times(1-6)
 * return： SUCCESS,ERR_INVALID_ARGUMENT, 
 *          Magnify times selecting was failed -- ERR_TEXT_SELECT_MAGNIFY_TIMES
**************************************************************************************************/
- (SInt32)textSelectFontMagnifyTimes:(SInt32)HorizontalTimes VerticalTimes:(SInt32)VerticalTimes;

/***************************************************************************************************
 * function: Rotate integer times 90 degree
 * Param list: Rotate:Rotate degree.RotatePrintNormal --normal; RotatePrintR90 -- clockwise 90;RotatePrint180 -- 180;RotatePrintL90 -- clockwise 270
 * return： SUCCESS,ERR_PROCESSING,
 *          Roration setting failed -- ERR_TEXT_STANDARD_MODE_ROTATE
**************************************************************************************************/
- (SInt32)textStandardModeRotate:(SInt32)Rotate;

/***************************************************************************************************
 * function: Select character font and font style
 * Param list: FontType: FontTypeStandardASCII –Standard ASCII Font selected;
 *                       FontTypeCompressedASCII  –Compressed ASCII font selected;
 *                       FontTypeUserDefined –User-defined character selected;
 *                       FontTypeChinese –Chinese font selected;
 *             FontStyle:FontStyleReverse\FontStyleBold\FontStyleUnderlineOneDotThick\FontStyleUnderlineTwoDotThick\FontStyleUpsideDown
 * return： SUCCESS,ERR_INVALID_ARGUMENT,The font type selecting failed -- ERR_TEXT_SELECT_FONT_TYPE,Reverse failed -- ERR_TEXT_SET_FONT_STYLE_REVERSE,Bold failed -- ERR_TEXT_SET_FONT_STYLE_BOLD,Underline failed -- ERR_TEXT_SET_FONT_STYLE_UNDERLINE,Upside-down failed -- ERR_TEXT_SET_FONT_STYLE_UPSIDEDOWN
**************************************************************************************************/
- (SInt32)textSelectFont:(SInt32)FontType FontStyle:(SInt32)FontStyle;

/***************************************************************************************************
 * function: text raster print in standard mode
 * Param list: TextToPrint:[in]the character which would be printed
 *             FontName:   [in] the font name be chose
 *             FontSize:   [in] the font size be chose
 * return：SUCCESS,Invalid parameter was passed/FontSize>PrinterWidth --ERR_INVALID_ARGUMENT,Image raster printing failed -- ERR_IMAGE_STANDARD_MODE_RASTER_PRINT,The data converted into raster image data was null -- ERR_INVALID_DATA
**************************************************************************************************/
- (SInt32)textStandardModeRasterPrint:(NSString*)TextToPrint FontName:(NSString*)FontName FontSize:(CGFloat)FontSize LineBreakMode:(NSLineBreakMode)LineBreakMode PrinterWidth:(SInt32)PrinterWidth;

/***************************************************************************************************
 * function: image print  
 * Param list:Mode:Image print mode:SingleDensity_8\DoubleDensity_8\SingleDensity_24\DoubleDensity_24;
 *            Image: the image would be print 
 *            StartHorPos:The parameter can not be used, and it fixed as 0
 *            PrinterWidth:Printer width[0,64-65535]
 * return：SUCCESS,Invalid parameter was passed/Image data was null --ERR_INVALID_ARGUMENT,
 *         Image downloading and printing failed -- ERR_IMAGE_DOWNLOAD_AND_PRINT,
 *         Allocing memory was failed -- ERR_ALLOC_MEMORY
**************************************************************************************************/
- (SInt32)imageStandardModePrint:(SInt32)Mode Image:(UIImage*)Image StartHorPos:(SInt32)StartHorPos PrinterWidth:(SInt32)PrinterWidth;

/***************************************************************************************************
 * function: Download image to RAM  
 * Param list:Image: the image would be Download ;
 *            ImageID:the ID of download [0-7]
 *            PrinterWidth:Printer width[[0,64-65535]
 * return：SUCCESS,Invalid parameter was passed/Image data was null --ERR_INVALID_ARGUMENT,
 *         RAM images downloading failed -- ERR_IMAGE_DOWNLOAD_RAM,
 *         Allocing memory was failed -- ERR_ALLOC_MEMORY,
 *         The image data converted was null -- ERR_INVALID_DATA
**************************************************************************************************/
- (SInt32)imageDownloadToPrinterRAM:(SInt32)ImageID Image:(UIImage*)Image PrinterWidth:(SInt32)PrinterWidth;

/***************************************************************************************************
 * function: Print image which downloaded to RAM  
 * Param list:ImageID: the image ID has been downloaded to RAM ;
 *            Mode:Print Mode:   NormalMode\Double_width\ Double_height\Quadruple
 * return： SUCCESS,ERR_INVALID_ARGUMENT,RAM image printing failed -- ERR_IMAGE_RAM_PRINT
**************************************************************************************************/
- (SInt32)imageRAMPrint:(SInt32)ImageID Mode:(SInt32)Mode;

/***************************************************************************************************
 * function: Download image to Flash  
 * Param list:ImageArray: the array of original image would be download to Flash[1-255]
 *            PrinterWidth:Printer width[[0,64-65535]
 * return：SUCCESS,Invalid parameter was passed/Image data was null --ERR_INVALID_ARGUMENT,
 *         Flash images downloading failed -- ERR_IMAGE_DOWNLOAD_Flash,
 *         Allocing memory was failed -- ERR_ALLOC_MEMORY,
 *         The image data converted was null -- ERR_INVALID_DATA
**************************************************************************************************/
- (SInt32)imageDownloadToPrinterFlash:(NSMutableArray*)ImageArray PrinterWidth:(SInt32)PrinterWidth;

/***************************************************************************************************
 * function: Print image which downloaded to Flash  
 * Param list:ImageID: the image ID has been downloaded to Flash ;
 *            Mode:Print Mode:   NormalMode\Double_width\ Double_height\Quadruple
 * return： SUCCESS,ERR_INVALID_ARGUMENT,Flash image printing failed -- ERR_IMAGE_FLASH_PRINT
**************************************************************************************************/
- (SInt32)imageFlashPrint:(SInt32)ImageID Mode:(SInt32)Mode;

/***************************************************************************************************
 * function: Print raster image in standard mode 
 * Param list:image: the image would be print;
 *            PrinterWidth:Printer width[[0,64-2040]
 * return：SUCCESS,Invalid parameter was passed/Image data==nil --ERR_INVALID_ARGUMENT,Image raster printing failed -- ERR_IMAGE_STANDARD_MODE_RASTER_PRINT,The data converted into raster image data was null -- ERR_INVALID_DATA
**************************************************************************************************/
- (SInt32)imageStandardModeRasterPrint:(UIImage*)Image PrinterWidth:(SInt32)PrinterWidth;

/***************************************************************************************************
 * function: Convert image format  
 * Param list:Image:The image would be convert;
 *            ditheringSupported: dithering is Supported or not 
 *            image_data:the image data
 * return： SUCCESS,Allocing memory was failed -- ERR_ALLOC_MEMORY
**************************************************************************************************/
- (SInt32)imageFormatConvertToUserDefinedData:(UIImage*)Image ditheringSupported:(BOOL)ditheringSupported image_data:(ImageDataRef*)image_data;

/***************************************************************************************************
 * function: Get barcode ID by comparing name of barcode
 * Param list: BarcodeName:BarcodeUPC-A\BarcodeUPC-E\BarcodeJAN13orEAN13\BarcodeJAN8orEAN8\BarcodeCODE39\BarcodeITF\BarcodeCODABAR\BarcodeCODE93\BarcodeCODE128
 * return： Success -- The name of specified barcode,Failed -- nil
**************************************************************************************************/
//- (SInt32)barcodeGetIDByName:(NSString*)BarcodeName;

/***************************************************************************************************
 * function: Get name by  barcode ID 
 * Param list: BarcodeID :0-8
 * return： Success -- The ID of specified barcode,Failed -- -1
**************************************************************************************************/
//- (NSString*)barcodeGetNameByID:(SInt32)BarcodeID;

/***************************************************************************************************
 * function: Print 1Dimension barcode
 * Param list: Data: barcode data
 *             BarcodeType:	BarcodeUPC_A \BarcodeUPC_E \BarcodeJAN13orEAN13 \ BarcodeJAN8orEAN8 \
 *                           BarcodeCODE39 \BarcodeITF\BarcodeCODABAR \BarcodeCODE93\BarcodeCODE128
 *             ModuleWidth:barcode module width[2 6]
 *             Height:barcode height[1 255]
 *             HriFontType:Hri Font Type(FontTypeStandardASCII \ FontTypeCompressedASCII)
 *             HriPosition:Hri Font Position:HRINone\HRIAbove\ HRIBelow\ HRIAboveAndBelow
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Barcode type selecting failed -- ERR_BARCODE_PRINT_1D
 *          Module width selecting failed --  ERR_BARCODE_SELECT_MODULE_WIDTH
 *          Barcode height selecting failed -- ERR_BARCODE_SELECT_BARCODE_HEIGHT
 *          Hri font type selecting failed -- ERR_BARCODE_SELECT_HRI_FONT_TYPE
 *          Hri position selecting failed -- ERR_BARCODE_SELECT_HRI_FONT_POSITION
 *          Data of barcode 1D sending failed -- ERR_BARCODE_1D_SEND_DATA
**************************************************************************************************/
- (SInt32)barcodePrint1Dimension:(NSData*)Data BarcodeType:(SInt32)Type ModuleWidth:(SInt32)ModuleWidth BarcodeHeight:(SInt32)Height HriFontType:(SInt32)HriFontType HriPosition:(SInt32)HriPosition;

/***************************************************************************************************
 * function: Print QR
 * Param list: Data:barcodeQR data
 *             BasicElementWidth:BasicElementWidth[1 10]
 *             SymbolType:OriginalType,EnhancedType
 *             LanguageMode:	LanguageChinese\LanguageJapanese
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *         The parameters of QR setting failed -- ERR_BARCODE_QR_SET_PARAM
 *         Barcode 2D type selecting to print failed -- ERR_BARCODE_PRINT_2D
 *         Barcode data of QR sending failed -- ERR_BARCODE_QR_SEND_DATA
**************************************************************************************************/
- (SInt32)barcodePrintQR:(NSData*)Data BasicElementWidth:(SInt32)BasicElementWidth SymbolType:(SInt32)SymbolType LanguageMode:(SInt32)LanguageMode;

/***************************************************************************************************
 * function: set barcodePDF417 size and print ODF417
 * Param list: Data:barcodePDF417 data
 *             AppearanceToHeight:Appearance to height[1-10];
 *             AppearanceToWidth:Appearance to width[1-100];
 *             RowNumber:the number of rows[3-90];
 *             ColumnNumber:the number of columns[1-30];
 *             XSize:[1-7];
 *             LineHeight:line height[2-25];
 *             CorrectionGrade:Correction Grade[0-8]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *         Barcode 2D type selecting to print failed -- ERR_BARCODE_PRINT_2D
 *         Barcode data of PDF417 sending failed -- ERR_BARCODE_PDF417_SEND_DATA
 *         PDF417 size setting failed -- ERR_BARCODE_PDF417_SET_SIZE
 *         PDF417 correction grade selecting failed -- ERR_BARCODE_PDF417_SELECT_CORRECTION_GRADE
**************************************************************************************************/
- (SInt32)barcodePrintPDF417:(NSData*)Data AppearanceToHeight:(SInt32)AppearanceToHeight AppearanceToWidth:(SInt32)AppearanceToWidth RowNumber:(SInt32)RowNumber ColumnNumber:(SInt32)ColumnNumber XSize:(SInt32)XSize LineHeight:(SInt32)LineHeight CorrectionGrade:(SInt32)CorrectionGrade;

/***************************************************************************************************
 * function: Print Maxicode
 * Param list: Data:Maxicode data
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *         Barcode 2D type selecting to print failed -- ERR_BARCODE_PRINT_2D
 *         Barcode data of Maxicode sending failed -- ERR_BARCODE_MAXICODE_SEND_DATA
**************************************************************************************************/
- (SInt32)barcodePrintMaxicode:(NSData*)Data;

/***************************************************************************************************
 * function: set GS1DataBar paramter
 * Param list: Data: GS1DataBar data
 *             BarcodeType: GS1DataBarOmnidirectional \ GS1DataBarTruncated\ GS1DataBarStacked\
 *                        GS1DataBarStackedOmnidirectional\ GS1DataBarLimited\ GS1DataBarExpanded\ GS1DataBarExpandedStacked
 *             BasicElementWidth:Basic element width[1-6];
 *             BarcodeHeight:Barcode height[2-250];
 *             BasicElementHeight:Basic element height[1-10];
 *             SeparatorHeight:Separator height[1-10];
 *             SegmentNumber:Segment number[2-20];
 *             HRI:HRI character.DataBarAnd2DHri\OnlyDataBarHri\Only2DHri\NoHri
 *             AI:whether to use AI[0-1]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *         Barcode 2D type selecting to print failed -- ERR_BARCODE_PRINT_2D
 *         Barcode data of GS1 sending failed -- ERR_BARCODE_GS1DATABAR_SEND_DATA
 *         Parameters of GS1 setting failed -- ERR_BARCODE_GS1DATABAR_SET_PARAM
**************************************************************************************************/
- (SInt32)barcodePrintGS1DataBar:(NSData*)Data BarcodeType:(SInt32)BarcodeType BasicElementWidth:(SInt32)BasicElementWidth BarcodeHeight:(SInt32)BarcodeHeight SegmentNumber:(SInt32)SegmentNumber SeparatorHeight:(SInt32)SeparatorHeight BasicElementHeight:(SInt32)BasicElementHeight HRI:(SInt32)HRI UseAI:(SInt32)AI;

/***************************************************************************************************
 * function: Set print area postion and width in standard mode 
 * Param list:LeftMargin:[0 65535]; 
 *            Width:print area width[0 65535].
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Print area width for standard mode setting failed -- ERR_STANDARD_MODE_SET_PRINTAREA_WIDTH
 *          Left margin for standard mode setting failed -- ERR_STANDARD_MODE_SET_LEFT_MARGIN
**************************************************************************************************/
- (SInt32)standardModeSetLeftMarginAndPrintAreaWidth:(SInt32)LeftMargin Width:(SInt32)Width;

/*********
 时间：2017-1-13
 function: set  left margin
 param: leftMargin:[0 65535]
 return： SUCCESS,ERR_INVALID_ARGUMENT
 Print area width for standard mode setting failed --
 ********/
-(SInt32)standardModeSetPrintLeftMargin:(SInt32)LeftMargin;

/*********
 时间：2017-1-13
 function: set  print width
 param: width:[0 65535]
 return： SUCCESS,ERR_INVALID_ARGUMENT
 Print area width for standard mode setting failed --
 ********/
-(SInt32)standardModeSetPrintWidth:(SInt32)width;

/*****************************
 时间：2017-1-13
 * function: Enter bi-colour print mode and set print color
 * Param list: PrintColorSetting select PrintColorNormal or PrintColorDouble
 * return： SUCCESS
 *          Failed to enter bi-color printing -- ERR_TEXT_ENTER_QUIT_COLOR_PRINT
 *          Color setting failed  -- ERR_TEXT_SET_COLOR_PRINT
 ＊设置双色打印
 ************************/
- (SInt32)textEnterOrQuitColorPrint:(SInt32)printColor;

/*****************************
 时间：2017-1-13
 * function: Enter bi-colour print mode and set print color
 * Param list: SelectColorSetting   select PrintColorFirst  ot  PrintColorSecond  to print
 * return： SUCCESS
 *          Failed to enter bi-color printing -- ERR_TEXT_ENTER_QUIT_COLOR_PRINT
 *          Color setting failed  -- ERR_TEXT_SET_COLOR_PRINT
 ＊限定双色选择另一种颜色
 ************************/
-(SInt32)textSetColorPrint:(SInt32)colorSelect;

/***********************************
 时间：2017-1-13
 * function: Horizontal Starting Position in standard mode
 * Param list: X:[0-65535]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Horizontal starting position for standard mode setting failed -- ERR_STANDARD_MODE_SET_HORIZONTAL_STARTING_POSITION
 ******************************/
- (SInt32)standardModeSetHorizontalStartingPosition:(SInt32)X;

/***************************************************************************************************
 * function: Horizontal Starting Position in standard mode
 * Param list: X:[0-65535]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Horizontal starting position for standard mode setting failed -- ERR_STANDARD_MODE_SET_HORIZONTAL_STARTING_POSITION
**************************************************************************************************/
- (SInt32)standardModeSetStartingPosition:(SInt32)X;

/***************************************************************************************************
 * function: Set Print Area in page mode
 * Param list: X:Horizontal starting position
 *             Y:Vertical starting position
 *             AreaWidth:Printing Area Width
 *             AreaHeight:Printing AreaHeight
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Print area for page mode setting failed -- ERR_PAGE_MODE_SET_PRINT_AREA
 *          Print direction for page mode setting failed -- ERR_PAGE_MODE_SET_PRINT_DIRECTION
**************************************************************************************************/
- (SInt32)pageModeSetPrintArea:(SInt32)X Y:(SInt32)Y AreaWidth:(SInt32)AreaWidth AreaHeight:(SInt32)AreaHeight PrintDirection:(SInt32)Direction;

/***************************************************************************************************
 * function: Horizontal and vertical Starting Position in page mode
 * Param list: X:[0-65535]
 *             Y:[0-65535].
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Horizontal starting position for standard mode setting failed -- ERR_STANDARD_MODE_SET_HORIZONTAL_STARTING_POSITION
 *          Vertical starting position for page mode setting failed -- ERR_PAGE_MODE_SET_VERTICAL_STARTING_POSITION
**************************************************************************************************/
- (SInt32)pageModeSetStartingPosition:(SInt32)X Y:(SInt32)Y;

/***************************************************************************************************
 * function: Print in page mode
 * Param list: none
 * return： SUCCESS
 *          Page mode printing failed -- ERR_PAGE_MODE_PRINT
**************************************************************************************************/
- (SInt32)pageModePrint;

/***************************************************************************************************
 * function: Clear buffer in page mode
 * Param list: none
 * return： SUCCESS
 *          Page mode clearing buffer failed -- ERR_PAGE_CLEAR_BUFFER
**************************************************************************************************/
- (SInt32)pageModeClearBuffer;

///***************************************************************************************************
// * function: Query the status of MSR
// * return： Success -- the status of Msr is ready,Failed -- ERR_MSR_QUERY_STATUS
// **************************************************************************************************/
//- (SInt32)MsrGetStatus_Old;
//
///***************************************************************************************************
// * function: Cancel swiping card
// * return： Success -- cancel success,Failed -- ERR_MSR_CANCEL_SWIP_CARD
// **************************************************************************************************/
//- (SInt32)MsrCancelSwipingCard_Old;
//
///***************************************************************************************************
// * function: Read magnetic data for the first track
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
// **************************************************************************************************/
//- (NSString*)MsrReadMagneticDataForFirstTrack_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: Read magnetic data for the second track
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
// **************************************************************************************************/
//- (NSString*)MsrReadMagneticDataForSecondTrack_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: Read magnetic data for the third track
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
// **************************************************************************************************/
//- (NSString*)MsrReadMagneticDataForThirdTrack_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: Read magnetic data for the three tracks
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
// **************************************************************************************************/
//- (NSString*)MsrReadMagneticDataForThreeTracks_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: IC Initializtion
// * return： Success -- initialization success !,Failed -- ERR_IC_INITIALIZATION
// **************************************************************************************************/
//- (SInt32)ICInitializtion_Old;
//
///***************************************************************************************************
// * function: Rest IC
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- open success !,Failed -- open failed !
// **************************************************************************************************/
//- (NSString*)ICRest_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: T0 protocol
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// *             CommandLength:the length of command
// *             Command:the command to be input
// * return： Success -- success ! and get the received data,Failed -- command runs failed !
// **************************************************************************************************/
//- (NSString*)ICControlT0_Old:(SInt32)CommandLength Command:(UInt8*)Command DataBuffer:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: T1 protocol
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// *             CommandLength:the length of command
// *             Command:the command to be input
// * return： Success -- success ! and get the received data,Failed -- command runs failed !
// **************************************************************************************************/
//- (NSString*)ICControlT1_Old:(SInt32)CommandLength Command:(UInt8*)Command DataBuffer:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: IC close
// * return： Success -- close success,Failed -- ERR_IC_CLOSE
// **************************************************************************************************/
//- (SInt32)ICClose_Old;
//
/***************************************************************************************************
 * function: Read magnetic data for the first track
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
 **************************************************************************************************/
- (NSString*)MsrReadMagneticDataForFirstTrack:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: Read magnetic data for the second track
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
 **************************************************************************************************/
- (NSString*)MsrReadMagneticDataForSecondTrack:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: Read magnetic data for the third track
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
 **************************************************************************************************/
- (NSString*)MsrReadMagneticDataForThirdTrack:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: Read magnetic data for the three tracks
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
 **************************************************************************************************/
- (NSString*)MsrReadMagneticDataForThreeTracks:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: Rest IC
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- success ! and get the received data,Failed -- command runs failed !
 **************************************************************************************************/
- (NSString*)ICRest:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: T0 protocol
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 *             CommandLength:the length of command
 *             Command:the command to be input
 * return： Success -- success ! and get the received data,Failed -- command runs failed !
 **************************************************************************************************/
- (NSString*)ICControlT0:(SInt32)CommandLength Command:(UInt8*)Command DataBuffer:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: T1 protocol
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 *             CommandLength:the length of command
 *             Command:the command to be input
 * return： Success -- success ! and get the received data,Failed -- command runs failed !
 **************************************************************************************************/
- (NSString*)ICControlT1:(SInt32)CommandLength Command:(UInt8*)Command DataBuffer:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

@end
